/**
 * Configurações do WebPlayer
 */

const CONFIG = {
    // URL da API
    API_URL: 'https://soupet.online/backend/index.php?url=',
    
    // Nome do App
    APP_NAME: 'Neuro Play IPTV',
    
    // Versão
    VERSION: '1.0.0',
    
    // Storage Keys
    STORAGE_KEYS: {
        AUTH_TOKEN: 'neuroplay_token',
        REFRESH_TOKEN: 'neuroplay_refresh',
        USER_DATA: 'neuroplay_user',
        CURRENT_PROFILE: 'neuroplay_profile',
        FAVORITES: 'neuroplay_favorites',
        WATCH_HISTORY: 'neuroplay_history'
    },
    
    // Configurações de Vídeo
    VIDEO: {
        AUTO_PLAY: true,
        DEFAULT_VOLUME: 0.8,
        REMEMBER_POSITION: true
    },
    
    // Categorias Especiais
    CATEGORIES: {
        ADULT: 'adulto',
        KIDS: 'infantil'
    },
    
    // Limites
    LIMITS: {
        MAX_PROFILES: 4,
        HISTORY_SIZE: 50,
        FAVORITES_SIZE: 100
    }
};
