<?php
/**
 * Classe para padronizar respostas JSON
 */
class Response {
    
    public static function success($data = null, $message = 'Sucesso', $statusCode = 200) {
        http_response_code($statusCode);
        echo json_encode([
            'success' => true,
            'message' => $message,
            'data' => $data
        ], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
        exit();
    }
    
    public static function error($message = 'Erro', $statusCode = 400, $errors = null) {
        http_response_code($statusCode);
        $response = [
            'success' => false,
            'message' => $message
        ];
        
        if ($errors !== null) {
            $response['errors'] = $errors;
        }
        
        echo json_encode($response, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
        exit();
    }
    
    public static function unauthorized($message = 'Não autorizado') {
        self::error($message, 401);
    }
    
    public static function forbidden($message = 'Acesso negado') {
        self::error($message, 403);
    }
    
    public static function notFound($message = 'Recurso não encontrado') {
        self::error($message, 404);
    }
}
