<?php
/**
 * Classe para registro de logs
 */
class Logger {
    
    public static function log($tipoUsuario, $usuarioId, $acao, $descricao = null, $dadosAdicionais = null) {
        if (!LOG_ENABLED) {
            return;
        }
        
        try {
            $db = Database::getAdminConnection();
            
            $sql = "INSERT INTO logs_sistema (tipo_usuario, usuario_id, acao, descricao, ip_address, user_agent, dados_adicionais) 
                    VALUES (:tipo_usuario, :usuario_id, :acao, :descricao, :ip_address, :user_agent, :dados_adicionais)";
            
            $stmt = $db->prepare($sql);
            $stmt->execute([
                'tipo_usuario' => $tipoUsuario,
                'usuario_id' => $usuarioId,
                'acao' => $acao,
                'descricao' => $descricao,
                'ip_address' => self::getIpAddress(),
                'user_agent' => $_SERVER['HTTP_USER_AGENT'] ?? null,
                'dados_adicionais' => $dadosAdicionais ? json_encode($dadosAdicionais) : null
            ]);
        } catch (Exception $e) {
            error_log("Erro ao registrar log: " . $e->getMessage());
        }
    }
    
    public static function logFile($message, $level = 'INFO') {
        if (!LOG_ENABLED) {
            return;
        }
        
        $logFile = LOG_PATH . date('Y-m-d') . '.log';
        $timestamp = date('Y-m-d H:i:s');
        $logMessage = "[{$timestamp}] [{$level}] {$message}" . PHP_EOL;
        
        if (!file_exists(LOG_PATH)) {
            mkdir(LOG_PATH, 0755, true);
        }
        
        file_put_contents($logFile, $logMessage, FILE_APPEND);
    }
    
    private static function getIpAddress() {
        if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
            return $_SERVER['HTTP_CLIENT_IP'];
        } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            return $_SERVER['HTTP_X_FORWARDED_FOR'];
        } else {
            return $_SERVER['REMOTE_ADDR'] ?? null;
        }
    }
}
