<?php
/**
 * Arquivo de Teste - Diagnóstico do Servidor
 */

header('Content-Type: application/json; charset=utf-8');

$diagnostico = [
    'status' => 'OK',
    'timestamp' => date('Y-m-d H:i:s'),
    'servidor' => [
        'php_version' => PHP_VERSION,
        'server_software' => $_SERVER['SERVER_SOFTWARE'] ?? 'Desconhecido',
        'document_root' => $_SERVER['DOCUMENT_ROOT'] ?? 'Desconhecido',
        'script_filename' => __FILE__,
        'request_uri' => $_SERVER['REQUEST_URI'] ?? 'Desconhecido'
    ],
    'extensoes' => [
        'pdo' => extension_loaded('pdo') ? 'OK' : 'FALTANDO',
        'pdo_mysql' => extension_loaded('pdo_mysql') ? 'OK' : 'FALTANDO',
        'json' => extension_loaded('json') ? 'OK' : 'FALTANDO',
        'mbstring' => extension_loaded('mbstring') ? 'OK' : 'FALTANDO',
        'curl' => extension_loaded('curl') ? 'OK' : 'FALTANDO'
    ],
    'mod_rewrite' => function_exists('apache_get_modules') && in_array('mod_rewrite', apache_get_modules()) ? 'OK' : 'VERIFICAR',
    'pastas' => [
        'uploads' => is_writable(__DIR__ . '/uploads') ? 'GRAVÁVEL' : 'SEM PERMISSÃO',
        'logs' => is_writable(__DIR__ . '/logs') ? 'GRAVÁVEL' : 'SEM PERMISSÃO',
        'cache' => is_writable(__DIR__ . '/cache') ? 'GRAVÁVEL' : 'SEM PERMISSÃO'
    ],
    'database' => [
        'admin_host' => defined('DB_ADMIN_HOST') ? 'Configurado' : 'Não configurado',
        'users_host' => defined('DB_USERS_HOST') ? 'Configurado' : 'Não configurado'
    ]
];

// Tentar conectar ao banco
try {
    require_once __DIR__ . '/config/database.php';
    $db = Database::getAdminConnection();
    $diagnostico['database']['conexao_admin'] = 'OK';
} catch (Exception $e) {
    $diagnostico['database']['conexao_admin'] = 'ERRO: ' . $e->getMessage();
}

try {
    $db = Database::getUsersConnection();
    $diagnostico['database']['conexao_users'] = 'OK';
} catch (Exception $e) {
    $diagnostico['database']['conexao_users'] = 'ERRO: ' . $e->getMessage();
}

echo json_encode($diagnostico, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
