/**
 * Gerenciamento de Autenticação
 */

const Auth = {
    // Verificar se está autenticado
    isAuthenticated() {
        return localStorage.getItem('access_token') !== null;
    },
    
    // Obter token
    getToken() {
        return localStorage.getItem('access_token');
    },
    
    // Obter usuário
    getUser() {
        const user = localStorage.getItem('user');
        return user ? JSON.parse(user) : null;
    },
    
    // Salvar autenticação
    setAuth(data) {
        localStorage.setItem('access_token', data.access_token);
        localStorage.setItem('refresh_token', data.refresh_token);
        localStorage.setItem('user', JSON.stringify(data.user));
    },
    
    // Limpar autenticação
    clearAuth() {
        localStorage.removeItem('access_token');
        localStorage.removeItem('refresh_token');
        localStorage.removeItem('user');
    },
    
    // Fazer login
    async login(email, senha, tipo) {
        try {
            const response = await fetch(CONFIG.API_URL + 'auth/login', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({ email, senha, tipo })
            });
            
            const data = await response.json();
            
            if (data.success) {
                this.setAuth(data.data);
                return { success: true };
            } else {
                return { success: false, message: data.message };
            }
        } catch (error) {
            return { success: false, message: 'Erro ao conectar com o servidor' };
        }
    },
    
    // Fazer logout
    async logout() {
        const refreshToken = localStorage.getItem('refresh_token');
        
        try {
            await fetch(CONFIG.API_URL + 'auth/logout', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': 'Bearer ' + this.getToken()
                },
                body: JSON.stringify({ refresh_token: refreshToken })
            });
        } catch (error) {
            console.error('Erro ao fazer logout:', error);
        }
        
        this.clearAuth();
        window.location.href = 'index.html';
    }
};
