/**
 * Cliente API
 */

const API = {
    // Fazer requisição autenticada
    async request(endpoint, options = {}) {
        const token = Auth.getToken();
        
        const defaultOptions = {
            headers: {
                'Content-Type': 'application/json',
                'Authorization': 'Bearer ' + token
            }
        };
        
        const finalOptions = {
            ...defaultOptions,
            ...options,
            headers: {
                ...defaultOptions.headers,
                ...options.headers
            }
        };
        
        try {
            const response = await fetch(CONFIG.API_URL + endpoint, finalOptions);
            const data = await response.json();
            
            // Se token expirou, fazer logout
            if (response.status === 401) {
                Auth.clearAuth();
                window.location.href = 'index.html';
                return null;
            }
            
            return data;
        } catch (error) {
            console.error('Erro na requisição:', error);
            return { success: false, message: 'Erro ao conectar com o servidor' };
        }
    },
    
    // GET
    async get(endpoint) {
        return this.request(endpoint, { method: 'GET' });
    },
    
    // POST
    async post(endpoint, data) {
        return this.request(endpoint, {
            method: 'POST',
            body: JSON.stringify(data)
        });
    },
    
    // PUT
    async put(endpoint, data) {
        return this.request(endpoint, {
            method: 'PUT',
            body: JSON.stringify(data)
        });
    },
    
    // DELETE
    async delete(endpoint) {
        return this.request(endpoint, { method: 'DELETE' });
    }
};
