<?php
/**
 * Middleware de Autenticação JWT
 */
class AuthMiddleware {
    
    public static function authenticate($requiredType = null) {
        $headers = getallheaders();
        $authHeader = $headers['Authorization'] ?? $headers['authorization'] ?? null;
        
        if (!$authHeader) {
            Response::unauthorized('Token não fornecido');
        }
        
        if (!preg_match('/Bearer\s+(.*)$/i', $authHeader, $matches)) {
            Response::unauthorized('Formato de token inválido');
        }
        
        $token = $matches[1];
        
        try {
            $payload = JWT::decode($token);
            
            if ($requiredType && $payload['tipo'] !== $requiredType) {
                Response::forbidden('Acesso negado para este tipo de usuário');
            }
            
            return $payload;
        } catch (Exception $e) {
            Response::unauthorized($e->getMessage());
        }
    }
    
    public static function authenticateAdmin() {
        return self::authenticate('admin');
    }
    
    public static function authenticateProvedor() {
        return self::authenticate('provedor');
    }
    
    public static function authenticateAdminOrProvedor() {
        $payload = self::authenticate();
        
        if (!in_array($payload['tipo'], ['admin', 'provedor'])) {
            Response::forbidden('Acesso negado');
        }
        
        return $payload;
    }
}
