<?php
/**
 * Neuro Play IPTV - Backend Entry Point
 * Router principal do sistema
 */

// Log de acesso
$logFile = __DIR__ . '/logs/access.log';
$logDir = dirname($logFile);
if (!is_dir($logDir)) {
    @mkdir($logDir, 0755, true);
}
$logMessage = date('Y-m-d H:i:s') . " - " . ($_SERVER['REQUEST_METHOD'] ?? 'UNKNOWN') . " - " . ($_SERVER['REQUEST_URI'] ?? 'UNKNOWN') . " - IP: " . ($_SERVER['REMOTE_ADDR'] ?? 'UNKNOWN') . "\n";
@file_put_contents($logFile, $logMessage, FILE_APPEND);

// Headers CORS
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
header('Content-Type: application/json; charset=utf-8');

// Responder OPTIONS para preflight
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Carregar configurações
try {
    require_once __DIR__ . '/config/config.php';
    require_once __DIR__ . '/config/database.php';
} catch (Exception $e) {
    $errorLog = __DIR__ . '/logs/error.log';
    @file_put_contents($errorLog, date('Y-m-d H:i:s') . " - ERRO AO CARREGAR CONFIG: " . $e->getMessage() . "\n", FILE_APPEND);
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Erro ao carregar configurações',
        'error' => $e->getMessage()
    ]);
    exit;
}

// Autoloader simples
spl_autoload_register(function ($class) {
    $directories = ['controllers', 'models', 'middleware', 'utils'];
    foreach ($directories as $dir) {
        $file = BASE_PATH . '/' . $dir . '/' . $class . '.php';
        if (file_exists($file)) {
            require_once $file;
            return;
        }
    }
});

// Capturar URL
$url = isset($_GET['url']) ? rtrim($_GET['url'], '/') : '';
$url = filter_var($url, FILTER_SANITIZE_URL);
$url = explode('/', $url);

// Roteamento
$endpoint = $url[0] ?? 'home';
$method = $_SERVER['REQUEST_METHOD'];

try {
    switch ($endpoint) {
        case 'auth':
            $controller = new AuthController();
            $controller->route($url, $method);
            break;
            
        case 'admin':
            $controller = new AdminController();
            $controller->route($url, $method);
            break;
            
        case 'provedor':
            $controller = new ProvedorController();
            $controller->route($url, $method);
            break;
            
        case 'usuario':
            $controller = new UsuarioController();
            $controller->route($url, $method);
            break;
            
        case 'perfil':
            $controller = new PerfilController();
            $controller->route($url, $method);
            break;
            
        case 'home':
        default:
            echo json_encode([
                'success' => true,
                'message' => 'Neuro Play IPTV API',
                'version' => API_VERSION
            ]);
            break;
    }
} catch (Exception $e) {
    // Log do erro
    $errorLog = __DIR__ . '/logs/error.log';
    $errorMessage = date('Y-m-d H:i:s') . " - ERRO: " . $e->getMessage() . "\n";
    $errorMessage .= "Trace: " . $e->getTraceAsString() . "\n\n";
    @file_put_contents($errorLog, $errorMessage, FILE_APPEND);
    
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Erro interno do servidor',
        'error' => $e->getMessage(),
        'trace' => $e->getTraceAsString()
    ]);
}
