<?php
/**
 * Debug Completo - Identificar Problema
 */

// Forçar exibição de erros
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/debug_errors.log');

echo "<h1>🔍 Debug - Neuro Play Backend</h1>";
echo "<hr>";

// 1. Informações do Servidor
echo "<h2>1. Informações do Servidor</h2>";
echo "<pre>";
echo "PHP Version: " . PHP_VERSION . "\n";
echo "Server Software: " . ($_SERVER['SERVER_SOFTWARE'] ?? 'Desconhecido') . "\n";
echo "Document Root: " . ($_SERVER['DOCUMENT_ROOT'] ?? 'Desconhecido') . "\n";
echo "Script Filename: " . __FILE__ . "\n";
echo "Current Directory: " . __DIR__ . "\n";
echo "Request URI: " . ($_SERVER['REQUEST_URI'] ?? 'Desconhecido') . "\n";
echo "HTTP Host: " . ($_SERVER['HTTP_HOST'] ?? 'Desconhecido') . "\n";
echo "</pre>";

// 2. Verificar Arquivos Essenciais
echo "<h2>2. Verificação de Arquivos</h2>";
echo "<pre>";

$arquivos = [
    'index.php',
    'config/config.php',
    'config/database.php',
    'controllers/AuthController.php',
    'utils/Response.php',
    '.htaccess'
];

foreach ($arquivos as $arquivo) {
    $caminho = __DIR__ . '/' . $arquivo;
    $existe = file_exists($caminho);
    $legivel = is_readable($caminho);
    
    echo sprintf(
        "%-40s %s %s\n",
        $arquivo,
        $existe ? '✓ Existe' : '✗ NÃO EXISTE',
        $legivel ? '✓ Legível' : '✗ NÃO LEGÍVEL'
    );
}
echo "</pre>";

// 3. Verificar Pastas
echo "<h2>3. Verificação de Pastas</h2>";
echo "<pre>";

$pastas = [
    'config',
    'controllers',
    'middleware',
    'utils',
    'database',
    'uploads',
    'logs',
    'cache',
    'tmp'
];

foreach ($pastas as $pasta) {
    $caminho = __DIR__ . '/' . $pasta;
    $existe = is_dir($caminho);
    $gravavel = is_writable($caminho);
    
    echo sprintf(
        "%-20s %s %s\n",
        $pasta . '/',
        $existe ? '✓ Existe' : '✗ NÃO EXISTE',
        $gravavel ? '✓ Gravável' : '✗ SEM PERMISSÃO'
    );
}
echo "</pre>";

// 4. Extensões PHP
echo "<h2>4. Extensões PHP</h2>";
echo "<pre>";

$extensoes = [
    'pdo',
    'pdo_mysql',
    'json',
    'mbstring',
    'curl',
    'gd',
    'zip'
];

foreach ($extensoes as $ext) {
    $carregada = extension_loaded($ext);
    echo sprintf(
        "%-20s %s\n",
        $ext,
        $carregada ? '✓ Carregada' : '✗ NÃO CARREGADA'
    );
}
echo "</pre>";

// 5. Testar Conexão com Banco
echo "<h2>5. Teste de Conexão com Banco de Dados</h2>";
echo "<pre>";

if (file_exists(__DIR__ . '/config/database.php')) {
    try {
        require_once __DIR__ . '/config/database.php';
        
        // Testar conexão Admin
        try {
            $dbAdmin = Database::getAdminConnection();
            echo "✓ Conexão com soupet_gerencia: OK\n";
            
            // Testar query
            $stmt = $dbAdmin->query("SELECT COUNT(*) as total FROM admins");
            $result = $stmt->fetch();
            echo "  - Total de admins: " . $result['total'] . "\n";
        } catch (Exception $e) {
            echo "✗ Erro na conexão Admin: " . $e->getMessage() . "\n";
        }
        
        // Testar conexão Users
        try {
            $dbUsers = Database::getUsersConnection();
            echo "✓ Conexão com soupet_provedor: OK\n";
            
            // Testar query
            $stmt = $dbUsers->query("SELECT COUNT(*) as total FROM usuarios");
            $result = $stmt->fetch();
            echo "  - Total de usuários: " . $result['total'] . "\n";
        } catch (Exception $e) {
            echo "✗ Erro na conexão Users: " . $e->getMessage() . "\n";
        }
        
    } catch (Exception $e) {
        echo "✗ Erro ao carregar database.php: " . $e->getMessage() . "\n";
    }
} else {
    echo "✗ Arquivo config/database.php não encontrado\n";
}
echo "</pre>";

// 6. Testar .htaccess
echo "<h2>6. Verificação do .htaccess</h2>";
echo "<pre>";

if (file_exists(__DIR__ . '/.htaccess')) {
    echo "✓ Arquivo .htaccess existe\n\n";
    echo "Conteúdo:\n";
    echo htmlspecialchars(file_get_contents(__DIR__ . '/.htaccess'));
} else {
    echo "✗ Arquivo .htaccess NÃO EXISTE\n";
}
echo "</pre>";

// 7. Variáveis de Ambiente
echo "<h2>7. Variáveis de Ambiente PHP</h2>";
echo "<pre>";
echo "display_errors: " . ini_get('display_errors') . "\n";
echo "error_reporting: " . error_reporting() . "\n";
echo "upload_max_filesize: " . ini_get('upload_max_filesize') . "\n";
echo "post_max_size: " . ini_get('post_max_size') . "\n";
echo "max_execution_time: " . ini_get('max_execution_time') . "\n";
echo "memory_limit: " . ini_get('memory_limit') . "\n";
echo "</pre>";

// 8. Teste de Escrita
echo "<h2>8. Teste de Escrita em Logs</h2>";
echo "<pre>";

$logFile = __DIR__ . '/debug_test.log';
$conteudo = "Teste de escrita: " . date('Y-m-d H:i:s') . "\n";

if (file_put_contents($logFile, $conteudo, FILE_APPEND)) {
    echo "✓ Conseguiu escrever em: " . $logFile . "\n";
} else {
    echo "✗ NÃO conseguiu escrever em: " . $logFile . "\n";
}
echo "</pre>";

echo "<hr>";
echo "<p><strong>Debug concluído em: " . date('Y-m-d H:i:s') . "</strong></p>";
