<?php
/**
 * Configurações de Banco de Dados
 * 2 Databases: Admin/Provedores e Usuários/Perfis
 */

// Database 1: Admin e Provedores
define('DB_ADMIN_HOST', 'localhost');
define('DB_ADMIN_NAME', 'soupet_gerencia');
define('DB_ADMIN_USER', 'soupet_gerencia');
define('DB_ADMIN_PASS', 'Flamengo@2015');
define('DB_ADMIN_CHARSET', 'utf8mb4');

// Database 2: Usuários e Perfis
define('DB_USERS_HOST', 'localhost');
define('DB_USERS_NAME', 'soupet_provedor');
define('DB_USERS_USER', 'soupet_provedor');
define('DB_USERS_PASS', 'Flamengo@2015');
define('DB_USERS_CHARSET', 'utf8mb4');

/**
 * Classe de Conexão com Banco de Dados
 */
class Database {
    private static $adminConnection = null;
    private static $usersConnection = null;

    /**
     * Conexão com Database Admin/Provedores
     */
    public static function getAdminConnection() {
        if (self::$adminConnection === null) {
            try {
                $dsn = "mysql:host=" . DB_ADMIN_HOST . ";dbname=" . DB_ADMIN_NAME . ";charset=" . DB_ADMIN_CHARSET;
                self::$adminConnection = new PDO($dsn, DB_ADMIN_USER, DB_ADMIN_PASS);
                self::$adminConnection->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
                self::$adminConnection->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
                self::$adminConnection->setAttribute(PDO::ATTR_EMULATE_PREPARES, false);
            } catch (PDOException $e) {
                error_log("Erro de conexão Admin DB: " . $e->getMessage());
                throw new Exception("Erro ao conectar ao banco de dados Admin");
            }
        }
        return self::$adminConnection;
    }

    /**
     * Conexão com Database Usuários/Perfis
     */
    public static function getUsersConnection() {
        if (self::$usersConnection === null) {
            try {
                $dsn = "mysql:host=" . DB_USERS_HOST . ";dbname=" . DB_USERS_NAME . ";charset=" . DB_USERS_CHARSET;
                self::$usersConnection = new PDO($dsn, DB_USERS_USER, DB_USERS_PASS);
                self::$usersConnection->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
                self::$usersConnection->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
                self::$usersConnection->setAttribute(PDO::ATTR_EMULATE_PREPARES, false);
            } catch (PDOException $e) {
                error_log("Erro de conexão Users DB: " . $e->getMessage());
                throw new Exception("Erro ao conectar ao banco de dados Usuários");
            }
        }
        return self::$usersConnection;
    }

    /**
     * Fechar conexões
     */
    public static function closeConnections() {
        self::$adminConnection = null;
        self::$usersConnection = null;
    }
}
