<?php
/**
 * Configurações Gerais do Sistema Neuro Play
 */

// Timezone
date_default_timezone_set('America/Sao_Paulo');

// Configurações de Erro (Desenvolvimento)
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Configurações de Sessão
ini_set('session.cookie_httponly', 1);
ini_set('session.use_only_cookies', 1);

// Constantes do Sistema
define('BASE_PATH', dirname(dirname(__FILE__)));
define('BASE_URL', 'https://soupet.online/backend');

// JWT Secret Key (ALTERAR EM PRODUÇÃO)
define('JWT_SECRET_KEY', 'neuro_play_secret_key_2024_change_in_production');
define('JWT_ALGORITHM', 'HS256');
define('JWT_EXPIRATION', 3600 * 24); // 24 horas
define('JWT_REFRESH_EXPIRATION', 3600 * 24 * 30); // 30 dias

// Configurações de Upload
define('UPLOAD_PATH', BASE_PATH . '/uploads/');
define('MAX_UPLOAD_SIZE', 5 * 1024 * 1024); // 5MB
define('ALLOWED_IMAGE_TYPES', ['image/jpeg', 'image/png', 'image/gif', 'image/webp']);

// Configurações de Paginação
define('ITEMS_PER_PAGE', 20);

// Configurações de Log
define('LOG_PATH', BASE_PATH . '/logs/');
define('LOG_ENABLED', true);

// Versão da API
define('API_VERSION', '1.0.0');
