# 🔧 Guia de Troubleshooting - Backend Neuro Play

## 🚨 Erro 404 - Not Found

### Passo 1: Verificar se os arquivos estão no servidor

Acesse via navegador:
```
https://soupet.online/backend/test.php
```

**Se aparecer JSON com diagnóstico:** ✅ Arquivos estão OK, vá para Passo 2
**Se aparecer 404:** ❌ Arquivos não foram enviados corretamente

---

### Passo 2: Testar index.php diretamente

Acesse:
```
https://soupet.online/backend/index.php
```

**Se aparecer JSON:** ✅ PHP está funcionando, vá para Passo 3
**Se aparecer 404 ou erro:** ❌ Problema com PHP ou permissões

---

### Passo 3: Testar roteamento manual

Acesse:
```
https://soupet.online/backend/index.php?url=auth/login
```

**Se funcionar:** ✅ Backend OK, problema é o .htaccess
**Se não funcionar:** ❌ Problema no código PHP

---

### Passo 4: Verificar .htaccess

#### Opção A: Substituir .htaccess

1. Renomear `.htaccess` atual para `.htaccess.old`
2. Renomear `.htaccess.cpanel` para `.htaccess`
3. Testar novamente: `https://soupet.online/backend/auth/login`

#### Opção B: Verificar mod_rewrite no cPanel

1. Acessar cPanel
2. Ir em "MultiPHP INI Editor" ou "Select PHP Version"
3. Verificar se `mod_rewrite` está habilitado

#### Opção C: Adicionar no .htaccess do diretório raiz

Se o backend está em `/public_html/backend/`, adicione no `.htaccess` da raiz (`/public_html/.htaccess`):

```apache
# Permitir .htaccess em subdiretórios
<Directory "/public_html/backend">
    AllowOverride All
</Directory>
```

---

### Passo 5: Verificar estrutura de pastas no servidor

A estrutura deve ser:
```
public_html/
└── backend/
    ├── .htaccess
    ├── index.php
    ├── test.php
    ├── config/
    ├── controllers/
    ├── middleware/
    ├── utils/
    ├── database/
    ├── uploads/
    ├── logs/
    ├── cache/
    └── tmp/
```

---

## 🔐 Problemas de Conexão com Banco de Dados

### Erro: "Access denied for user"

1. Verificar credenciais em `config/database.php`
2. Criar usuários no MySQL via cPanel:
   - Usuário: `soupet_gerencia`
   - Senha: `Flamengo@2015`
   - Banco: `soupet_gerencia`

3. Dar permissões ao usuário no banco

### Erro: "Unknown database"

Criar os bancos de dados:
```sql
CREATE DATABASE soupet_gerencia;
CREATE DATABASE soupet_provedor;
```

Importar schemas:
```bash
mysql -u soupet_gerencia -p soupet_gerencia < database/schema_admin.sql
mysql -u soupet_provedor -p soupet_provedor < database/schema_users.sql
```

---

## 📁 Problemas de Permissão

### Erro: "Permission denied" ao fazer upload

Dar permissões corretas:
```bash
chmod 755 backend/uploads
chmod 755 backend/logs
chmod 755 backend/cache
chmod 755 backend/tmp
```

Ou via cPanel File Manager:
1. Clicar com botão direito na pasta
2. "Change Permissions"
3. Marcar: Read, Write, Execute para Owner
4. Marcar: Read, Execute para Group e Public

---

## 🧪 Testes Rápidos

### Teste 1: PHP Info
Criar arquivo `info.php`:
```php
<?php phpinfo(); ?>
```
Acessar: `https://soupet.online/backend/info.php`

### Teste 2: Diagnóstico Completo
Acessar: `https://soupet.online/backend/test.php`

### Teste 3: Teste de Rota
Acessar: `https://soupet.online/backend/`
Deve retornar:
```json
{
  "success": true,
  "message": "Neuro Play IPTV API",
  "version": "1.0.0"
}
```

---

## 📞 Checklist de Deploy

- [ ] Arquivos enviados via FTP/cPanel
- [ ] Bancos de dados criados
- [ ] Usuários MySQL criados e com permissões
- [ ] Schemas SQL importados
- [ ] Arquivo `config/database.php` configurado
- [ ] Arquivo `config/config.php` configurado (BASE_URL)
- [ ] Pastas com permissões corretas (755)
- [ ] `.htaccess` configurado corretamente
- [ ] mod_rewrite habilitado
- [ ] PHP 7.4+ instalado
- [ ] Extensões PHP necessárias instaladas

---

## 🆘 Soluções Alternativas

### Se .htaccess não funcionar de jeito nenhum

Modificar todas as chamadas para incluir `index.php`:
```
https://soupet.online/backend/index.php?url=auth/login
```

Ou configurar o servidor para usar `index.php` como fallback no cPanel.

---

## 📧 Logs de Erro

Verificar logs em:
- cPanel → Errors
- `backend/logs/` (se configurado)
- `error_log` na raiz do servidor
