# Backend - Neuro Play IPTV

API RESTful em PHP para gerenciamento de provedores IPTV, usuários e perfis.

## 📁 Estrutura de Pastas

```
Backend/
├── config/
│   ├── config.php          # Configurações gerais
│   └── database.php        # Conexões de banco de dados
│
├── controllers/
│   ├── AuthController.php      # Autenticação
│   ├── AdminController.php     # Painel Admin
│   ├── ProvedorController.php  # Painel Provedores
│   ├── UsuarioController.php   # Usuários
│   └── PerfilController.php    # Perfis
│
├── middleware/
│   └── AuthMiddleware.php  # Middleware JWT
│
├── utils/
│   ├── JWT.php             # Gerenciamento JWT
│   ├── Response.php        # Respostas padronizadas
│   ├── Validator.php       # Validação de dados
│   ├── Logger.php          # Sistema de logs
│   └── M3UParser.php       # Parser de playlists
│
├── database/
│   ├── schema_admin.sql    # Schema Admin/Provedores
│   └── schema_users.sql    # Schema Usuários/Perfis
│
├── uploads/                # Arquivos enviados
├── logs/                   # Logs do sistema
├── .htaccess              # Configuração Apache
└── index.php              # Entry point
```

## 🔧 Configuração

### 1. Banco de Dados

Editar `config/database.php`:

```php
// Database Admin/Provedores
define('DB_ADMIN_HOST', 'localhost');
define('DB_ADMIN_NAME', 'neuroplay_admin');
define('DB_ADMIN_USER', 'seu_usuario');
define('DB_ADMIN_PASS', 'sua_senha');

// Database Usuários/Perfis
define('DB_USERS_HOST', 'localhost');
define('DB_USERS_NAME', 'neuroplay_users');
define('DB_USERS_USER', 'seu_usuario');
define('DB_USERS_PASS', 'sua_senha');
```

### 2. Configurações Gerais

Editar `config/config.php`:

```php
define('BASE_URL', 'http://seu-dominio.com/backend');
define('JWT_SECRET_KEY', 'sua_chave_secreta_aqui');
```

### 3. Criar Bancos de Dados

```bash
mysql -u root -p < database/schema_admin.sql
mysql -u root -p < database/schema_users.sql
```

## 🚀 Uso

### Autenticação Admin/Provedor

```javascript
// Login
POST /auth/login
{
  "email": "admin@neuroplay.com",
  "senha": "admin123",
  "tipo": "admin" // ou "provedor"
}

// Resposta
{
  "success": true,
  "message": "Login realizado com sucesso",
  "data": {
    "access_token": "eyJ0eXAiOiJKV1QiLCJhbGc...",
    "refresh_token": "a1b2c3d4e5f6...",
    "user": {
      "id": 1,
      "nome": "Administrador",
      "email": "admin@neuroplay.com",
      "tipo": "admin"
    }
  }
}
```

### Requisições Autenticadas

Incluir header:
```
Authorization: Bearer {access_token}
```

### Renovar Token

```javascript
POST /auth/refresh
{
  "refresh_token": "a1b2c3d4e5f6..."
}
```

## 📊 Modelos de Dados

### Provedor
```json
{
  "id": 1,
  "numero_provedor": "12345",
  "nome": "Provedor IPTV XYZ",
  "email": "contato@provedor.com",
  "logo": "uploads/logo.png",
  "banner": "uploads/banner.jpg",
  "url_principal": "http://provedor.com/playlist.m3u",
  "url_backup_1": "http://backup1.provedor.com/playlist.m3u",
  "url_backup_2": "http://backup2.provedor.com/playlist.m3u",
  "categoria_adulto_id": "18",
  "categoria_infantil_id": "KIDS",
  "ativo": 1,
  "data_vencimento": "2024-12-31"
}
```

### Usuário
```json
{
  "id": 1,
  "provedor_id": 1,
  "numero_provedor": "12345",
  "login_provedor": "usuario123",
  "nome": "João Silva",
  "idioma": "pt-BR",
  "controle_parental_ativo": 1,
  "pin_parental": "1234"
}
```

### Perfil
```json
{
  "id": 1,
  "usuario_id": 1,
  "nome": "Principal",
  "avatar": "avatar_01.png",
  "tipo": "principal",
  "pin_protegido": 1,
  "infantil": 0
}
```

## 🔐 Segurança

### JWT
- Tokens expiram em 24 horas
- Refresh tokens válidos por 30 dias
- Algoritmo HS256
- Secret key configurável

### Senhas
- Hash bcrypt
- Custo padrão: 10

### SQL Injection
- Prepared statements em todas as queries
- PDO com emulação desabilitada

### XSS
- Sanitização de inputs
- Headers de segurança configurados

## 📝 Logs

Logs são salvos em:
- Banco de dados: `logs_sistema`
- Arquivos: `logs/YYYY-MM-DD.log`

Tipos de log:
- Login/Logout
- CRUD de provedores
- CRUD de mensagens/novidades
- Erros do sistema

## 🐛 Debug

Para ativar modo debug, editar `config/config.php`:

```php
error_reporting(E_ALL);
ini_set('display_errors', 1);
```

**IMPORTANTE:** Desativar em produção!

## 📈 Performance

### Recomendações:
1. Habilitar OPcache no PHP
2. Usar cache Redis para sessões
3. Implementar CDN para uploads
4. Otimizar queries com índices
5. Implementar rate limiting

## 🔄 Versionamento

Versão atual: **1.0.0**

Para atualizar a versão da API:
```sql
UPDATE configuracoes_gerais SET valor = '1.1.0' WHERE chave = 'versao_app';
```
